/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.drivers;

import java.util.EnumSet;
import javax.vecmath.Point3d;
import org.w3c.dom.Node;
import replicatorg.app.exceptions.BuildFailureException;
import replicatorg.drivers.DriverError;
import replicatorg.drivers.RetryException;
import replicatorg.drivers.Version;
import replicatorg.drivers.VersionException;
import replicatorg.machine.model.AxisId;
import replicatorg.machine.model.MachineModel;
import replicatorg.util.Point5d;

public interface Driver {
    public void loadXML(Node var1);

    public boolean isPassthroughDriver();

    public void executeGCodeLine(String var1);

    public boolean isFinished();

    public boolean isBufferEmpty();

    public void assessState();

    public boolean hasError();

    public DriverError getError();

    public void checkErrors() throws BuildFailureException;

    public void initialize() throws VersionException;

    public void uninitialize();

    public boolean isInitialized();

    public void dispose();

    public MachineModel getMachine();

    public void setMachine(MachineModel var1);

    public String getDriverName();

    public String getFirmwareInfo();

    public Version getVersion();

    public void updateManualControl();

    public Version getMinimumVersion();

    public Version getPreferredVersion();

    public void setCurrentPosition(Point5d var1) throws RetryException;

    public void storeHomePositions(EnumSet<AxisId> var1) throws RetryException;

    public void recallHomePositions(EnumSet<AxisId> var1) throws RetryException;

    public boolean positionLost();

    public Point5d getCurrentPosition(boolean var1);

    public void invalidatePosition();

    public void queuePoint(Point5d var1) throws RetryException;

    public Point3d getOffset(int var1);

    public void setOffsetX(int var1, double var2);

    public void setOffsetY(int var1, double var2);

    public void setOffsetZ(int var1, double var2);

    public Point5d getPosition();

    public void requestToolChange(int var1, int var2) throws RetryException;

    public void selectTool(int var1) throws RetryException;

    public void setFeedrate(double var1);

    public double getCurrentFeedrate();

    public void homeAxes(EnumSet<AxisId> var1, boolean var2, double var3) throws RetryException;

    public void delay(long var1) throws RetryException;

    public void openClamp(int var1);

    public void closeClamp(int var1);

    public void enableDrives() throws RetryException;

    public void disableDrives() throws RetryException;

    public void changeGearRatio(int var1);

    public void readToolStatus();

    public int getToolStatus();

    public void setMotorDirection(int var1);

    public void setMotorRPM(double var1) throws RetryException;

    public void setMotorSpeedPWM(int var1) throws RetryException;

    public double getMotorRPM();

    public int getMotorSpeedPWM();

    public void enableMotor() throws RetryException;

    public void enableMotor(long var1) throws RetryException;

    public void disableMotor() throws RetryException;

    public void setSpindleRPM(double var1) throws RetryException;

    public void setSpindleSpeedPWM(int var1) throws RetryException;

    public void setSpindleDirection(int var1);

    public double getSpindleRPM();

    public int getSpindleSpeedPWM();

    public void enableSpindle() throws RetryException;

    public void disableSpindle() throws RetryException;

    public void setTemperature(double var1) throws RetryException;

    public void readTemperature();

    public double getTemperature();

    public double getTemperatureSetting();

    public void setPlatformTemperature(double var1) throws RetryException;

    public void readPlatformTemperature();

    public double getPlatformTemperature();

    public double getPlatformTemperatureSetting();

    public void setChamberTemperature(double var1);

    public void readChamberTemperature();

    public double getChamberTemperature();

    public void enableFloodCoolant();

    public void disableFloodCoolant();

    public void enableMistCoolant();

    public void disableMistCoolant();

    public void enableFan() throws RetryException;

    public void disableFan() throws RetryException;

    public void openValve() throws RetryException;

    public void closeValve() throws RetryException;

    public void openCollet();

    public void closeCollet();

    public void pause();

    public void unpause();

    public void stop(boolean var1);

    public boolean hasSoftStop();

    public boolean hasEmergencyStop();

    public void reset();

    public boolean heartbeat();
}

